﻿// See https://aka.ms/new-console-template for more information


using System.Threading;
Console.Title = "Tic Tac Toe";
Console.ForegroundColor = ConsoleColor.Blue;
Console.Beep();

// game start
Console.WriteLine("Enter Player One's name:");
Console.ForegroundColor = ConsoleColor.Magenta;
string playerOneName = Console.ReadLine();
Player playerOne = new Player(playerOneName, ConsoleColor.Magenta); // Symbol X


Console.ForegroundColor = ConsoleColor.Blue;
Console.WriteLine("Enter Player Two's name:");
Console.ForegroundColor = ConsoleColor.Green;
string playerTwoName = Console.ReadLine();
Player playerTwo = new Player(playerTwoName, true, ConsoleColor.Green); // Symbol O


// Game loop
GameBoard gameBoard = new GameBoard();

while (true)
{
    // Player One's Turn
    gameBoard.DisplayBoard(playerOne, playerTwo);
    
    // Prompt Player One
    Console.ForegroundColor = ConsoleColor.Blue; 
    Console.Write($"{playerOne.Name}, choose your square (1-9): ");
    
    
    //player ones move 
    int move; // Variable to hold Player One's move
    while (true) // Loop until Player One makes a valid move
    { 
        if (int.TryParse(Console.ReadLine(), out move) && move >= 1 && move <= 9)
        {
            if (gameBoard.UpdateBoard(move, playerOne.Symbol))
            {
                // Display move
                Console.ForegroundColor = ConsoleColor.Magenta;
                Console.WriteLine($"{playerOne.Name} (X) moved.");
                Console.ResetColor(); 
                
                
                // Check for winner after Player One's move
                char? winner = gameBoard.CheckForWinner();
                if (winner.HasValue)
                {
                    gameBoard.DisplayBoard(playerOne, playerTwo);
                    Console.ForegroundColor = ConsoleColor.Yellow;
                    Console.WriteLine($"Congratulations {playerOneName}! {winner.Value} wins!");
                    return; // Exit the game loop
                }
                // Check for tie
                
                if (gameBoard.IsBoardFull())
                {
                    gameBoard.DisplayBoard(playerOne, playerTwo);
                    Console.ForegroundColor = ConsoleColor.DarkCyan;
                    Console.WriteLine("It's a CAT! The game is a tie!");
                    return; // Exit the game loop
                }
                
                break; // Exit loop for Player One's turn
            }
        }
        else
        {
            Console.WriteLine("Invalid input. Please enter a number between 1 and 9.");
        }
        
        // Re-prompt for Player One's move
        Console.Write($"{playerOne.Name}, choose your square (1-9): ");
    }

    // Player Two's Turn
    gameBoard.DisplayBoard(playerOne, playerTwo);
    Console.ForegroundColor = ConsoleColor.Blue;
    
    int moveForPlayerTwo; // Variable to hold Player Two's move

    while (true) // Loop until Player Two makes a valid move
    {
        Console.Write($"{playerTwo.Name}, choose your square (1-9): ");
        
        if (int.TryParse(Console.ReadLine(), out moveForPlayerTwo) && moveForPlayerTwo >= 1 && moveForPlayerTwo <= 9)
        {
            // Attempt to update the board and check if it was successful
            if (gameBoard.UpdateBoard(moveForPlayerTwo, playerTwo.Symbol))
            {
                // Display Player Two's move in green
                Console.ForegroundColor = ConsoleColor.Green;
                Console.WriteLine($"{playerTwo.Name} (O) moved.");
                Console.ResetColor(); 
                // Check for winner after Player One's move
                char? winner = gameBoard.CheckForWinner();
                if (winner.HasValue)
                {
                    gameBoard.UpdateBoard(moveForPlayerTwo, playerTwo.Symbol);
                    Console.ForegroundColor = ConsoleColor.Yellow;
                    Console.WriteLine($"Congratulations, {playerTwoName}! {winner.Value} wins!");
                    return; // Exit the game loop
                }
                
                // Check for tie 
                if (gameBoard.IsBoardFull())
                {
                    gameBoard.DisplayBoard(playerOne, playerTwo);
                    Console.ForegroundColor = ConsoleColor.DarkCyan;
                    Console.WriteLine("It's a CAT! The game is a tie!");
                    return; // Exit the game loop
                }
                
                break; // exit loop
            }
        }
        else
        {
            Console.WriteLine("Invalid input. Please enter a number between 1 and 9.");
        }
    }
}


public class Player
{
 public char Symbol { get; }
 public string Name { get; }
 public ConsoleColor Color { get; }

 // player one
 public Player(string name,ConsoleColor color)
 {
     Symbol = 'X';
     Name = name;
     Color=color;
     Console.ForegroundColor = color;
     Console.WriteLine($" Hello {Name}, your symbol will be {Symbol}");
     Console.ResetColor();
 }
 // player two
 public Player(string name, bool isPlayerTwo, ConsoleColor color)
 {
     Name = name;
     Symbol = 'O';
     Color=color;
     Console.ForegroundColor = color;
     Console.WriteLine($" Hello {Name}, your symbol will be {Symbol}");
     Console.ResetColor();
 }
}

public class GameBoard
{
    private char[,] _board;
    public const int Size = 3;

    public GameBoard()
    {
        _board = new char[Size, Size]; // 3x3 board size
        for (int i = 0; i < Size; i++)
        {
            for (int j = 0; j < Size; j++)
            {
                _board[i, j] = ' ';
            }
        }
    }

    public void DisplayBoard(Player playerOne, Player playerTwo)
    {
        Thread.Sleep(1550);
        Console.Clear();
        Console.ForegroundColor = ConsoleColor.Blue; // Set the initial color for the board

        for (int i = 0; i < Size; i++)
        {
            for (int j = 0; j < Size; j++)
            {
                // Set the color based on the symbol on the board
                if (_board[i, j] == playerOne.Symbol)
                {
                    Console.ForegroundColor = playerOne.Color; // Color for Player One
                }
                else if (_board[i, j] == playerTwo.Symbol)
                {
                    Console.ForegroundColor = playerTwo.Color; // Color for Player Two
                }
                else
                {
                    Console.ResetColor(); // Reset color for empty spaces
                }

                Console.Write($" {_board[i, j]} ");
                if (j < Size - 1)
                {
                    Console.ForegroundColor = ConsoleColor.Blue; // Set color for the column separator
                    Console.Write("|"); // Column separator
                }
            }

            Console.WriteLine();
            if (i < Size - 1)
            {
                Console.ForegroundColor = ConsoleColor.Blue; // Set color for the row separator
                Console.WriteLine("---+---+---"); // Row separator
            }
        }

        Console.ResetColor(); // Reset color after displaying the board
    }
    
    // update the board on move 
    public bool UpdateBoard(int move, char playersymbol)
    {
        int row = (move - 1) / Size;
        int column = (move - 1) % Size;
        if (_board[row, column] == ' ') // check if empty
        {
            _board[row,column] = playersymbol;
            return true;
        }
        else
        {
            Console.WriteLine("Square is already occupied. Choose another.");
            return false;
        }
    }

    public char? CheckForWinner()
    {
        // Check rows for a win
        for (int i = 0; i < Size; i++)
        {
            if (_board[i, 0] != ' ' && _board[i, 0] == _board[i, 1] && _board[i, 1] == _board[i, 2])
            {
                return _board[i, 0]; // Return the winning symbol
            }
        }

        // Check columns 
        for (int j = 0; j < Size; j++)
        {
            if (_board[0, j] != ' ' && _board[0, j] == _board[1, j] && _board[1, j] == _board[2, j])
            {
                return _board[0, j]; // Return symbol
            }
        }

        // Check diagonals
        if (_board[0, 0] != ' ' && _board[0, 0] == _board[1, 1] && _board[1, 1] == _board[2, 2])
        {
            return _board[0, 0]; // Return symbol
        }
        if (_board[0, 2] != ' ' && _board[0, 2] == _board[1, 1] && _board[1, 1] == _board[2, 0])
        {
            return _board[0, 2]; 
        }

        return null; // No winner 
    }
    
    public bool IsBoardFull()
    {
        for (int i = 0; i < Size; i++)
        {
            for (int j = 0; j < Size; j++)
            {
                if (_board[i, j] == ' ') // If any cell is empty
                {
                    return false; // The board is not full
                }
            }
        }
        return true; // The board is full
    }
}


