﻿
int round = 0;
int roundMax = 2;
int currentRound = 1;
while (round < roundMax)
{
    Console.WriteLine($" Round: {currentRound} / {roundMax}");
    Hangman hangman = new Hangman();
    hangman.Play();
    currentRound++;
}

public class Player
{
    public string Name { get; set; }

    public Player(string name)
    {
        Name = name;
    }
}


// board and gameplay loop
public class Hangman
{
    private Dictionary dictionary;
    
    private string WordToGuess { get; set; }
    private string DisplayBoard { get; set; }
    private int RemainingGuesses { get; set; }
    private char CurrentGuess { get; set; }
    private List<char> Guesses { get; set; }
    private bool IsGameOver { get; set; }
    private Player player;

    //
    public Hangman()
    {
        dictionary = new Dictionary();
        player = new Player("Player 1"); // or prompt for name
        InitializeGame();
        InitializeDisplayBoard();
    }
    
    private void InitializeGame()
    {
        WordToGuess = dictionary.PickRandom();
        InitializeDisplayBoard();
        RemainingGuesses = 6; // or however many you choose
        Guesses = new List<char>();
        IsGameOver = false;
    }

    // board 
    private void InitializeDisplayBoard()
    { 
        DisplayBoard = string.Join(" ", WordToGuess.Select(c => c == ' ' ? " " : "_")); // Creates the board with spaces
    }
    
    // current gameboard 
    public void DisplayGameState()
    {
        Console.ForegroundColor = ConsoleColor.Blue;
        Console.Write($"Word: {DisplayBoard} | ");
        
        
        Console.Write($"Remaining: {RemainingGuesses} |");
        Console.ForegroundColor = ConsoleColor.Red;
        Console.Write($"Incorrect: {string.Join("", Guesses)}");
        Console.ForegroundColor = ConsoleColor.Blue;
        Console.WriteLine($"| Guess: {CurrentGuess}");
    }
    
private void Guess(char guessing)
{
    CurrentGuess = guessing; // Store the current guess directly
    char lowerCurrentGuess = char.ToLower(CurrentGuess);

    if (!Guesses.Contains(lowerCurrentGuess)) // Check if the guess has been made
    {
        Guesses.Add(lowerCurrentGuess); // Add to the list of past guesses

        // Check if the guess is correct
        if (!WordToGuess.ToLower().Contains(lowerCurrentGuess))
        {
            RemainingGuesses--; // Decrease the remaining guesses if incorrect
            Console.WriteLine($"Incorrect guess! You have {RemainingGuesses} remaining.");
        }
        else
        {
            // Update the display board
            char[] displayArray = DisplayBoard.Replace(" ", "").ToCharArray(); // Remove spaces for updating

            for (int i = 0; i < WordToGuess.Length; i++)
            {
                // Check for matching characters, accounting for case
                if (char.ToLower(WordToGuess[i]) == lowerCurrentGuess)
                {
                    // Ensure the index is within bounds
                    if (i >= 0 && i < displayArray.Length)
                    {
                        displayArray[i] = WordToGuess[i]; // Fill in the correct letter
                    }
                }
            }

            // Rebuild the display board with spaces included
            DisplayBoard = string.Join(" ",
                WordToGuess.Select(c => c == ' ' ? " " : (Guesses.Contains(char.ToLower(c)) ? c.ToString() : "_")));
        }

        // Check for win condition
        if (WordToGuess.All(c => Guesses.Contains(char.ToLower(c)) || c == ' '))
        {
            Console.WriteLine($"Congratulations! You've guessed the word: {WordToGuess}");
            IsGameOver = true; // Set the game over flag
        }
    }
    else
    {
        Console.WriteLine($"You already guessed '{CurrentGuess}'. Try again!");
    }
}

    // Gameplay loop method
    public void Play()
    {
        while (!IsGameOver)
        {
            DisplayGameState();
            Console.Write("Enter your guess: ");
            char guess = Console.ReadKey().KeyChar;
            Console.WriteLine(); // Move to the next line
            Guess(guess);
            

            // Check if the game is over
            if (RemainingGuesses <= 0)
            {
                Console.WriteLine("Game Over! The word was: " + WordToGuess);
                IsGameOver = true;
            }

            //  all letters guessed
            if (!DisplayBoard.Contains("_") && (RemainingGuesses >0))
            {
                IsGameOver = true;
            }
        }
    }
}



public class Dictionary
{
    public string[] Wordlist =
    {
        "Gecs", "Marcy Playground", "Radiohead", "Modest Mouse", "Rod Stewart", "The Beatles", "No Doubt", "Pixies",
        "House of Pain", "DILLY DALLY", "The Cardigans", "Bloc Party"
    };

    public Random rnd = new Random(); // initialize the Random field here

    public string PickRandom()
    {
        return Wordlist[rnd.Next(0, Wordlist.Length)];
    }
}
